import os

from game_object import *

class Floor(GameObjectNonAnimated):
    IMAGE = pygame.image.load(os.path.join("data", "floor.png"))
    
class Wall(GameObjectNonAnimated):
    IMAGE = pygame.image.load(os.path.join("data", "wall.png"))

class House(GameObjectNonAnimated):
    IMAGE = pygame.image.load(os.path.join("data", "house.png"))

class HelpText(TextObject):
    FONT_SIZE = 28 # before scale
    FONT_SCALE = 2

    def __init__(self, text, level, colnum, rownum, *groups):
        self.text = text
        TextObject.__init__(self, level, colnum, rownum, *groups)

    def update_text(self):
        pass