import os

import pygame
from pygame.locals import *

class Intro(object):
    RESULT_QUIT = 0
    RESULT_PLAY = 1

    def __init__(self, screen):
        self.screen = screen
        self.background = pygame.image.load(os.path.join("data", "intro.png")).convert_alpha()

    def loop(self):
        # Draw background
        self.screen.blit(self.background, (0, 0))
        pygame.display.update()

        # Wait for keypress (Enter/Escape)
        while True:
            for event in pygame.event.get():
                result = self.handle_event(event)
                if result is not None:
                    return result

    def handle_event(self, event):
        if event.type == QUIT or (event.type == KEYUP and event.key == K_ESCAPE):
            return self.RESULT_QUIT

        elif event.type == KEYDOWN and event.key == K_RETURN:
            return self.RESULT_PLAY
        