import os

from game_object import *

class DollarScoreImage(GameObjectNonAnimated):
    IMAGE = pygame.image.load(os.path.join("data", "dollar.png"))

class PotionScoreImage(GameObjectNonAnimated):
    IMAGE = pygame.image.load(os.path.join("data", "potion.png"))

class ScoreCounter(TextObject):
    DISTANCE = 10 # pixels
    
    def __init__(self, level, counter_image, *groups):
        self.counter_image = counter_image
        self.arect = self.counter_image.arect
        TextObject.__init__(self, level, 0, 0, *groups)

    def update(self, *args):
        TextObject.update(self, *args)
        self.arect.centery = self.counter_image.arect.centery
        self.arect.left = self.counter_image.arect.right + self.DISTANCE

class DollarScoreCounter(ScoreCounter):
    def update_text(self):
        self.text = "x %d" % self.level.game.money

class PotionScoreCounter(ScoreCounter):
    def update_text(self):
        self.text = "x %d" % self.level.num_potions
