import os
import random

from person import *

class Woman(Person):
    ACTIVATION_DISTANCE = WINDOW_WIDTH / 2

    JUMP_SOUNDS = ["oooh.wav", "muah.wav", "eee.wav"]
    
    def __init__(self, level, *groups):
        Person.__init__(self, level, *groups)

        self.active = False

        # Slightly randomize her speed and acceleration +/- 20%
        speed_factor = random.uniform(0.8, 1.2)
        self.INITIAL_MOVE_VELOC *= speed_factor
        self.MOVE_ACCEL *= speed_factor
        self.MOVE_ACCEL_DURATION *= speed_factor
        self.INITIAL_JUMP_VELOC *= speed_factor

        # Random amount of money between 80 and 120
        self.money = random.randrange(80, 120 + 1)

        self.animate(True) # to initially flip

    @classmethod
    def random(cls):
        return random.choice([Blonde, Brunette, Redhead, Blackhair])

    def update_position(self):
        Person.update_position(self)

        if not self.active:
            # If this woman is close to the man, she should activate
            #distance_to_man_squared = (self.arect.centerx - self.level.man.arect.centerx) ** 2 + \
            #                          (self.arect.centery - self.level.man.arect.centery) ** 2
            #
            #if distance_to_man_squared < self.ACTIVATION_DISTANCE ** 2:
            #    self.active = True
            distance_to_man = abs(self.arect.centerx - self.level.man.arect.centerx)

            if distance_to_man < self.ACTIVATION_DISTANCE:
                self.active = True

        if self.active:
            if self.level.man.ugly:
                # Go away from the man
                if self.arect.centerx > self.level.man.arect.centerx:
                    self.start_move_right()
                else:
                    self.start_move_left()
            else:
                # Go towards the man
                if self.arect.centerx > self.level.man.arect.centerx:
                    self.start_move_left()
                else:
                    self.start_move_right()

            # Jump 3% of the time
            if random.randrange(100) < 1:
                pygame.mixer.Sound(os.path.join("data", random.choice(self.JUMP_SOUNDS))).play()
                self.jump()

class Blonde(Woman):
    IMAGES = { "normal" :
                   [ pygame.image.load(os.path.join("data", "blonde1.png")),
                     pygame.image.load(os.path.join("data", "blonde2.png")) ] }

    INITIAL_MOVE_VELOC = 40    # pixels per second
    MOVE_ACCEL = 150           # pixels per second^2
    MOVE_ACCEL_DURATION = 1.6  # seconds of acceleration

    INITIAL_JUMP_VELOC = 400  # pixels per second
    GRAVITY_ACCEL = 800       # pixels per second^2

class Redhead(Woman):
    IMAGES = { "normal" :
                   [ pygame.image.load(os.path.join("data", "redhead1.png")),
                     pygame.image.load(os.path.join("data", "redhead2.png")) ] }

    INITIAL_MOVE_VELOC = 30    # pixels per second
    MOVE_ACCEL = 200           # pixels per second^2
    MOVE_ACCEL_DURATION = 1.3  # seconds of acceleration

    INITIAL_JUMP_VELOC = 300  # pixels per second
    GRAVITY_ACCEL = 800       # pixels per second^2

class Brunette(Woman):
    IMAGES = { "normal" :
                   [ pygame.image.load(os.path.join("data", "brunette1.png")),
                     pygame.image.load(os.path.join("data", "brunette2.png")) ] }

    INITIAL_MOVE_VELOC = 50    # pixels per second
    MOVE_ACCEL = 100           # pixels per second^2
    MOVE_ACCEL_DURATION = 1.7  # seconds of acceleration

    INITIAL_JUMP_VELOC = 400  # pixels per second
    GRAVITY_ACCEL = 800       # pixels per second^2

class Blackhair(Woman):
    IMAGES = { "normal" :
                   [ pygame.image.load(os.path.join("data", "blackhair1.png")),
                     pygame.image.load(os.path.join("data", "blackhair2.png")) ] }

    INITIAL_MOVE_VELOC = 20    # pixels per second
    MOVE_ACCEL = 100           # pixels per second^2
    MOVE_ACCEL_DURATION = 6.5  # seconds of acceleration

    INITIAL_JUMP_VELOC = 400  # pixels per second
    GRAVITY_ACCEL = 800       # pixels per second^2
