import os

import pygame
from pygame.locals import *

from game_consts import *

class Background(object):
    # Note - this class slightly abuses the Sprite paradigm (and isn't a Sprite)... forgive me
    IMAGE = os.path.join("data", "background-gradient.png")
    
    def __init__(self, screen_size):
        width, height = screen_size
        
        self.surf = pygame.Surface((width, height)).convert()
        self.image = pygame.image.load(self.IMAGE).convert()
        
        for i in xrange(width):
            self.surf.blit(self.image, (i, 0))

    def draw(self, screen):
        screen.blit(self.surf, (0, 0))
