from intro import *
from level import *

from lose_screen import *
from win_screen import *

class Game(object):
    def __init__(self):
        pygame.init()

        # Create screen
        icon = pygame.image.load(os.path.join("data", "icon.png"))
        pygame.display.set_icon(icon)
        pygame.display.set_caption(WINDOW_CAPTION)
        self.screen = pygame.display.set_mode(WINDOW_SIZE)

        # Load level set
        self.level_filenames = [f.strip() for f in file(os.path.join("data", "levelset.txt"), "r").readlines()]

    def reset_game(self):
        # Load levels
        self.money = 0
        self.levels = [Level(self, level_filename, self.screen) for level_filename in self.level_filenames]

    def play(self):
        intro = Intro(self.screen)
        lose = LoseScreen(self.screen)
        win = WinScreen(self.screen)

        self.level_idx = 0

        intro_result = intro.loop()

        while intro_result == Intro.RESULT_PLAY:
            self.reset_game()

            level = None
            level_result = None

            while self.level_idx < len(self.levels):
                level = self.levels[self.level_idx]
                level_result = level.loop()

                if level_result == Level.LEVEL_RESULT_QUIT:
                    break
                elif level_result == Level.LEVEL_RESULT_LOSE:
                    break
                elif level_result == Level.LEVEL_RESULT_WIN:
                    pygame.time.delay(1000)
                    self.level_idx += 1
            
            if level_result == Level.LEVEL_RESULT_LOSE:
                pygame.time.delay(1500)
                lose.loop(level.lost_girl)
            elif level_result == Level.LEVEL_RESULT_QUIT:
                # do intro again
                self.level_idx = 0
                intro_result = intro.loop()
            else:
                # won!
                win.loop()
                # do intro again
                self.level_idx = 0
                intro_result = intro.loop()
                
                
        pygame.quit()