from woman import *

class LoseScreen(object):
    def __init__(self, screen):
        self.screen = screen
        self.lose_blonde = pygame.image.load(os.path.join("data", "lose_blonde.png")).convert_alpha()
        self.lose_brunette = pygame.image.load(os.path.join("data", "lose_brunette.png")).convert_alpha()
        self.lose_redhead = pygame.image.load(os.path.join("data", "lose_redhead.png")).convert_alpha()
        self.lose_blackhair = pygame.image.load(os.path.join("data", "lose_blackhair.png")).convert_alpha()

    def loop(self, girl):
        # Draw background
        if isinstance(girl, Blonde):
            background = self.lose_blonde
        elif isinstance(girl, Brunette):
            background = self.lose_brunette
        elif isinstance(girl, Redhead):
            background = self.lose_redhead
        elif isinstance(girl, Blackhair):
            background = self.lose_blackhair

        self.screen.blit(background, (0, 0))
        pygame.display.update()

        # Wait for keypress (Enter/Escape)
        while True:
            for event in pygame.event.get():
                if not self.handle_event(event):
                    return

    def handle_event(self, event):
        if event.type == QUIT or (event.type == KEYUP and event.key == K_ESCAPE):
            return False

        elif event.type == KEYDOWN and event.key == K_RETURN:
            return False

        return True
