import os

import pygame
from pygame.locals import *

class WinScreen(object):
    def __init__(self, screen):
        self.screen = screen
        self.background = pygame.image.load(os.path.join("data", "win.png")).convert_alpha()

    def loop(self):
        # Draw background
        self.screen.blit(self.background, (0, 0))
        pygame.display.update()

        # Wait for keypress (Enter/Escape)
        while True:
            for event in pygame.event.get():
                if not self.handle_event(event):
                    return

    def handle_event(self, event):
        if event.type == QUIT or (event.type == KEYUP and event.key == K_ESCAPE):
            return False

        elif event.type == KEYDOWN and event.key == K_RETURN:
            return False

        return True
